<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Migration_Version_312 extends CI_Migration
{
    public function __construct()
    {
        parent::__construct();
    }

    public function up()
    {
        add_option('allow_non_admin_members_to_delete_tickets_and_replies', '1');
        add_option('required_register_fields', '[]');

        add_option('invoice_company_national_id', '1');
        add_option('invoice_company_registration_number', '1');

        if (!$this->db->field_exists('invoice_company_national_id', db_prefix() . 'companies')) {
            $this->db->query('ALTER TABLE `' . db_prefix() . 'companies` ADD `invoice_company_national_id` VARCHAR(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL;');
        }

        if (!$this->db->field_exists('invoice_company_registration_number', db_prefix() . 'companies')) {
            $this->db->query('ALTER TABLE `' . db_prefix() . 'companies` ADD `invoice_company_registration_number` VARCHAR(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL;');
        }

        if (!$this->db->field_exists('client_national_id', db_prefix() . 'clients')) {
            $this->db->query('ALTER TABLE `' . db_prefix() . 'clients` ADD `client_national_id` VARCHAR(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL;');
        }

        if (!$this->db->field_exists('client_registration_number', db_prefix() . 'clients')) {
            $this->db->query('ALTER TABLE `' . db_prefix() . 'clients` ADD `client_registration_number` VARCHAR(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL;');
        }
    }
}
