<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');
$CI  =&get_instance();
/*
Module Name: idpay
Module URI: https://freshcode.ir
Author: Kamal Rahimi - Laniakea
Author URI: https://laniakea-co.com
Description: ماژول درگاه پرداخت آیدی پی برای اسکریپت Perfex CRM.
Version: 1.0.0
Requires at least: 2.3.*
*/
define('IDPAY_MODULE_NAME', 'idpay');
register_payment_gateway('idpay_gateway', 'idpay');

/**
* Register activation module hook
*/
register_activation_hook(IDPAY_MODULE_NAME, 'idpay_module_activation_hook');
$CI->load->helper(IDPAY_MODULE_NAME . '/idpay_core');

/**
 * Register idpay language files
 */
register_language_files(IDPAY_MODULE_NAME, ['idpay']);

function idpay_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}