<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: کوتاه کننده لینک
Module URI: https://freshcode.ir
Author: Kamal Rahimi - Laniakea
Author URI: https://freshcode.ir
Description: ماژول کوتاه کننده لینک برای اسکریپت Perfex CRM
Version: 1.0.0
*/

define('URL_SHORTNER_MODULE_NAME', 'url_shortner');
$CI = &get_instance();

hooks()->add_action('admin_init', 'url_shortner_init_menu_items');

/**
* Load the module helper
*/
$CI->load->helper(URL_SHORTNER_MODULE_NAME . '/url_shortner_core');




/**
* Register activation module hook
*/
register_activation_hook(URL_SHORTNER_MODULE_NAME, 'url_shortner_module_activation_hook');

function url_shortner_module_activation_hook()
{
    $CI = &get_instance();
}

/**
* Register language files, must be registered if the module is using languages
*/
register_language_files(URL_SHORTNER_MODULE_NAME, [URL_SHORTNER_MODULE_NAME]);


/**
 * Init menu setup module menu items in setup in admin_init hook
 * @return null
 */
function url_shortner_init_menu_items()
{
    /**
    * If the logged in user is administrator, add custom menu in Setup
    */
    $CI = &get_instance();
    if (is_admin()) {
        $CI->app_menu->add_setup_menu_item('url_shortener', [
            'href'     => admin_url('url_shortner'),
            'name'     => _l('url_shortener'),
            'position' => 45,
            'badge'    => [],
        ]);
    }
}



