<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */
defined('BASEPATH') or exit('No direct script access allowed');
$CI  =&get_instance();
/*
Module Name: zibal
Module URI: https://freshcode.ir
Author: Kamal Rahimi - Laniakea
Author URI: https://laniakea-co.com
Description: ماژول درگاه پرداخت زیبال برای اسکریپت Perfex CRM.
Version: 1.0.0
Requires at least: 2.3.*
*/
define('ZIBAL_MODULE_NAME', 'zibal');
register_payment_gateway('zibal_gateway', 'zibal');

/**
* Register activation module hook
*/
register_activation_hook(ZIBAL_MODULE_NAME, 'zibal_module_activation_hook');
$CI->load->helper(ZIBAL_MODULE_NAME . '/zibal_core');

/**
 * Register zibal language files
 */
register_language_files(ZIBAL_MODULE_NAME, ['zibal']);

function zibal_module_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}